<?php
return array(
    // Set this option false to remove demo in the assets path
    'use_demo' => true,

    // Product
    'product'  => array(
        'name'        => 'Metronic',
        'description' => 'Metronic - Bootstrap 5 HTML, VueJS, React, Angular & Laravel Admin Dashboard Theme',
        'preview'     => 'https://preview.keenthemes.com/metronic8/laravel',
        'home'        => 'https://keenthemes.com/metronic',
        'purchase'    => 'https://1.envato.market/EA4JP',
        'licenses'    => array(
            'terms' => 'https://themeforest.net/licenses/standard',
            'types' => array(
                array(
                    'title'       => 'Regular License',
                    'description' => 'For single end product used by you or one client',
                    'tooltip'     => 'Use, by you or one client in a single end product which end users are not charged for',
                    'price'       => '39',
                ),
                array(
                    'title'       => 'Extended License',
                    'description' => 'For single SaaS app with paying users',
                    'tooltip'     => 'Use, by you or one client, in a single end product which end users can be charged for.',
                    'price'       => '939',
                ),
            ),
        ),
        'demos'       => array(
            'demo1' => array(
                'title'       => 'Demo 1',
                'description' => 'Default Dashboard',
                'published'   => true,
                'thumbnail'   => 'demos/demo1.png',
            ),

            'demo2' => array(
                'title'       => 'Demo 2',
                'description' => 'SaaS Application',
                'published'   => true,
                'thumbnail'   => 'demos/demo2.png',
            ),

            'demo3' => array(
                'title'       => 'Demo 3',
                'description' => 'New Trend',
                'published'   => true,
                'thumbnail'   => 'demos/demo3.png',
            ),

            'demo4' => array(
                'title'       => 'Demo 4',
                'description' => 'Intranet Application',
                'published'   => true,
                'thumbnail'   => 'demos/demo4.png',
            ),

            'demo5' => array(
                'title'       => 'Demo 5',
                'description' => 'Support Forum',
                'published'   => true,
                'thumbnail'   => 'demos/demo5.png',
            ),

            'demo6' => array(
                'title'       => 'Demo 6',
                'description' => 'Admin Backend',
                'published'   => true,
                'thumbnail'   => 'demos/demo6.png',
            ),

            'demo7' => array(
                'title'       => 'Demo 7',
                'description' => 'CRM Dashboard',
                'published'   => true,
                'thumbnail'   => 'demos/demo7.png',
            ),

            'demo8' => array(
                'title'       => 'Demo 8',
                'description' => 'Core Dashboard',
                'published'   => true,
                'thumbnail'   => 'demos/demo8.png',
            ),

            'demo9' => array(
                'title'       => 'Demo 9',
                'description' => 'Fancy Dashboard',
                'published'   => true,
                'thumbnail'   => 'demos/demo9.png',
            ),

            'demo10' => array(
                'title'       => 'Demo 10',
                'description' => 'Project Grid',
                'published'   => false,
                'thumbnail'   => 'demos/demo10.png',
            ),

            'demo11' => array(
                'title'       => 'Demo 11',
                'description' => 'Light Dashboard',
                'published'   => false,
                'thumbnail'   => 'demos/demo11.png',
            ),

            'demo12' => array(
                'title'       => 'Demo 12',
                'description' => 'Creative Dashboard',
                'published'   => false,
                'thumbnail'   => 'demos/demo12.png',
            ),

            'demo13' => array(
                'title'       => 'Demo 13',
                'description' => 'Classic Dashboard',
                'published'   => false,
                'thumbnail'   => 'demos/demo13.png',
            ),

            'demo14' => array(
                'title'       => 'Demo 14',
                'description' => 'Interactive Dashboard',
                'published'   => false,
                'thumbnail'   => 'demos/demo14.png',
            ),

            'demo15' => array(
                'title'       => 'Demo 15',
                'description' => 'Member Dashboard',
                'published'   => false,
                'thumbnail'   => 'demos/demo15.png',
            ),

            'demo16' => array(
                'title'       => 'Demo 16',
                'description' => 'Modern Dashboard',
                'published'   => false,
                'thumbnail'   => 'demos/demo16.png',
            ),

            'demo17' => array(
                'title'       => 'Demo 17',
                'description' => 'Fancy Dashboard',
                'published'   => false,
                'thumbnail'   => 'demos/demo17.png',
            ),

            'demo18' => array(
                'title'       => 'Demo 18',
                'description' => 'Minimalistic Dashboard',
                'published'   => false,
                'thumbnail'   => 'demos/demo18.png',
            ),

            'demo19' => array(
                'title'       => 'Demo 19',
                'description' => 'Futuristic Dashboard',
                'published'   => false,
                'thumbnail'   => 'demos/demo19.png',
            ),

            'demo20' => array(
                'title'       => 'Demo 20',
                'description' => 'Advanced Dashboard',
                'published'   => false,
                'thumbnail'   => 'demos/demo20.png',
            ),

            'demo21' => array(
                'title'       => 'Demo 21',
                'description' => 'Monochrome Dashboard',
                'published'   => false,
                'thumbnail'   => 'demos/demo21.png',
            ),

            'demo22' => array(
                'title'       => 'Demo 22',
                'description' => 'Social Dashboard',
                'published'   => false,
                'thumbnail'   => 'demos/demo22.png',
            ),

            'demo23' => array(
                'title'       => 'Demo 23',
                'description' => 'SaaS Dashboard',
                'published'   => false,
                'thumbnail'   => 'demos/demo23.png',
            ),

            'demo24' => array(
                'title'       => 'Demo 24',
                'description' => 'Compact Dashboard',
                'published'   => false,
                'thumbnail'   => 'demos/demo24.png',
            ),

        ),
    ),

    // Meta
    'meta'     => array(
        'title'       => 'Metronic - the world\'s #1 selling Bootstrap Admin Theme Ecosystem for HTML, Vue, React, Angular & Laravel',
        'description' => 'The most advanced Bootstrap Admin Theme on Themeforest trusted by 94,000 beginners and professionals. Multi-demo, Dark Mode, RTL support and complete React, Angular, Vue & Laravel versions. Grab your copy now and get life-time updates for free.',
        'keywords'    => 'Metronic, bootstrap, bootstrap 5, Angular, VueJs, React, Laravel, admin themes, web design, figma, web development, free templates, free admin themes, bootstrap theme, bootstrap template, bootstrap dashboard, bootstrap dak mode, bootstrap button, bootstrap datepicker, bootstrap timepicker, fullcalendar, datatables, flaticon',
        'canonical'   => 'https://preview.keenthemes.com/metronic8',
    ),

    // General
    'general'  => array(
        'website'             => 'https://keenthemes.com',
        'about'               => 'https://keenthemes.com',
        'contact'             => 'mailto:support@keenthemes.com',
        'support'             => 'https://keenthemes.com/support',
        'bootstrap-docs-link' => 'https://getbootstrap.com/docs/5.0',
        'licenses'            => 'https://keenthemes.com/licensing',
        'social-accounts'     => array(
            array(
                'name' => 'Youtube', 'url' => 'https://www.youtube.com/c/KeenThemesTuts/videos', 'logo' => 'svg/social-logos/youtube.svg', "class" => "h-20px",
            ),
            array(
                'name' => 'Github', 'url' => 'https://github.com/KeenthemesHub', 'logo' => 'svg/social-logos/github.svg', "class" => "h-20px",
            ),
            array(
                'name' => 'Twitter', 'url' => 'https://twitter.com/keenthemes', 'logo' => 'svg/social-logos/twitter.svg', "class" => "h-20px",
            ),
            array(
                'name' => 'Instagram', 'url' => 'https://www.instagram.com/keenthemes', 'logo' => 'svg/social-logos/instagram.svg', "class" => "h-20px",
            ),

            array(
                'name' => 'Facebook', 'url' => 'https://www.facebook.com/keenthemes', 'logo' => 'svg/social-logos/facebook.svg', "class" => "h-20px",
            ),
            array(
                'name' => 'Dribbble', 'url' => 'https://dribbble.com/keenthemes', 'logo' => 'svg/social-logos/dribbble.svg', "class" => "h-20px",
            ),
        ),
    ),

    // Layout
    'layout'   => array(
        // Docs
        'docs'          => array(
            'logo-path'  => array(
                'default' => 'logos/logo-1.svg',
                'dark'    => 'logos/logo-1-dark.svg',
            ),
            'logo-class' => 'h-25px',
        ),

        // Illustration
        'illustrations' => array(
            'set' => 'sketchy-1',
        ),
    ),

    // Vendors
    'vendors'  => array(
        "datatables"             => array(
            "css" => array(
                "plugins/custom/datatables/datatables.bundle.css",
            ),
            "js"  => array(
                "plugins/custom/datatables/datatables.bundle.js",
            ),
        ),
        "formrepeater"           => array(
            "js" => array(
                "plugins/custom/formrepeater/formrepeater.bundle.js",
            ),
        ),
        "fullcalendar"           => array(
            "css" => array(
                "plugins/custom/fullcalendar/fullcalendar.bundle.css",
            ),
            "js"  => array(
                "plugins/custom/fullcalendar/fullcalendar.bundle.js",
            ),
        ),
        "flotcharts"             => array(
            "js" => array(
                "plugins/custom/flotcharts/flotcharts.bundle.js",
            ),
        ),
        "google-jsapi"           => array(
            "js" => array(
                "//www.google.com/jsapi",
            ),
        ),
        "tinymce"                => array(
            "js" => array(
                "plugins/custom/tinymce/tinymce.bundle.js",
            ),
        ),
        "ckeditor-classic"       => array(
            "js" => array(
                "plugins/custom/ckeditor/ckeditor-classic.bundle.js",
            ),
        ),
        "ckeditor-inline"        => array(
            "js" => array(
                "plugins/custom/ckeditor/ckeditor-inline.bundle.js",
            ),
        ),
        "ckeditor-balloon"       => array(
            "js" => array(
                "plugins/custom/ckeditor/ckeditor-balloon.bundle.js",
            ),
        ),
        "ckeditor-balloon-block" => array(
            "js" => array(
                "plugins/custom/ckeditor/ckeditor-balloon-block.bundle.js",
            ),
        ),
        "ckeditor-document"      => array(
            "js" => array(
                "plugins/custom/ckeditor/ckeditor-document.bundle.js",
            ),
        ),
        "draggable"              => array(
            "js" => array(
                "plugins/custom/draggable/draggable.bundle.js",
            ),
        ),
        "fslightbox"             => array(
            "js" => array(
                "plugins/custom/fslightbox/fslightbox.bundle.js",
            ),
        ),
        "jkanban"                => array(
            "css" => array(
                "plugins/custom/jkanban/jkanban.bundle.css",
            ),
            "js"  => array(
                "plugins/custom/jkanban/jkanban.bundle.js",
            ),
        ),
        "typedjs"                => array(
            "js" => array(
                "plugins/custom/typedjs/typedjs.bundle.js",
            ),
        ),
        "cookiealert"            => array(
            "css" => array(
                "plugins/custom/cookiealert/cookiealert.bundle.css",
            ),
            "js"  => array(
                "plugins/custom/cookiealert/cookiealert.bundle.js",
            ),
        ),
        "cropper"                => array(
            "css" => array(
                "plugins/custom/cropper/cropper.bundle.css",
            ),
            "js"  => array(
                "plugins/custom/cropper/cropper.bundle.js",
            ),
        ),
        "vis-timeline"           => array(
            "css" => array(
                "plugins/custom/vis-timeline/vis-timeline.bundle.css",
            ),
            "js"  => array(
                "plugins/custom/vis-timeline/vis-timeline.bundle.js",
            ),
        ),
        "jstree"                 => array(
            "css" => array(
                "plugins/custom/jstree/jstree.bundle.css",
            ),
            "js"  => array(
                "plugins/custom/jstree/jstree.bundle.js",
            ),
        ),
        "prismjs"                => array(
            "css" => array(
                "plugins/custom/prismjs/prismjs.bundle.css",
            ),
            "js"  => array(
                "plugins/custom/prismjs/prismjs.bundle.js",
            ),
        ),
        "leaflet"                => array(
            "css" => array(
                "plugins/custom/leaflet/leaflet.bundle.css",
            ),
            "js"  => array(
                "plugins/custom/leaflet/leaflet.bundle.js",
            ),
        ),
        "amcharts"               => array(
            "js" => array(
                "https://cdn.amcharts.com/lib/5/index.js",
                "https://cdn.amcharts.com/lib/5/xy.js",
                "https://cdn.amcharts.com/lib/5/percent.js",
                "https://cdn.amcharts.com/lib/5/radar.js",
                "https://cdn.amcharts.com/lib/5/themes/Animated.js",
            ),
        ),
        "amcharts-maps"          => array(
            "js" => array(
                "https://cdn.amcharts.com/lib/5/index.js",
                "https://cdn.amcharts.com/lib/5/map.js",
                "https://cdn.amcharts.com/lib/5/geodata/worldLow.js",
                "https://cdn.amcharts.com/lib/5/geodata/continentsLow.js",
                "https://cdn.amcharts.com/lib/5/geodata/usaLow.js",
                "https://cdn.amcharts.com/lib/5/geodata/worldTimeZonesLow.js",
                "https://cdn.amcharts.com/lib/5/geodata/worldTimeZoneAreasLow.js",
                "https://cdn.amcharts.com/lib/5/themes/Animated.js",
            ),
        ),
        "amcharts-stock"         => array(
            "js" => array(
                "https://cdn.amcharts.com/lib/5/index.js",
                "https://cdn.amcharts.com/lib/5/xy.js",
                "https://cdn.amcharts.com/lib/5/themes/Animated.js",
            ),
        ),
        'bootstrap-select'       => array(
            'css' => array(
                'plugins/custom/bootstrap-select/bootstrap-select.bundle.css',
            ),
            'js'  => array(
                'plugins/custom/bootstrap-select/bootstrap-select.bundle.js',
            ),
        ),
    ),

);
