<?php
    // Tasks items
    $listRows = array(
        array(
            'icon' => 'icons/duotune/abstract/abs027.svg',
            'color' => 'success',
            'title' => 'Project Briefing',
            'description' => 'Project Manager',
        ),

        array(
            'icon' => 'icons/duotune/art/art005.svg',
            'color' => 'warning',
            'title' => 'Concept Design',
            'description' => 'Art Director'
        ),

        array(
            'icon' => 'icons/duotune/communication/com012.svg',
            'color' => 'primary',
            'title' => 'Functional Logics',
            'description' => 'Lead Developer'
        ),

        array(
            'icon' => 'icons/duotune/coding/cod008.svg',
            'color' => 'danger',
            'title' => 'Development',
            'description' => 'DevOps'
        ),

        array(
            'icon' => 'icons/duotune/general/gen049.svg',
            'color' => 'info',
            'title' => 'Testing',
            'description' => 'QA Managers'
        ),

        array(
            'icon' => 'icons/duotune/files/fil010.svg',
            'color' => 'success',
            'title' => 'HTML, CSS Coding',
            'description' => 'Art Director'
        ),

        array(
            'icon' => 'icons/duotune/graphs/gra008.svg',
            'color' => 'danger',
            'title' => 'ReactJS Developer',
            'description' => 'Web, UI/UX Design'
        )
    );
?>

<!--begin::Tasks-->
<div class="mx-5">
    <!--begin::Header-->
    <h3 class="fw-bolder text-dark mb-10 mx-0">
        Tasks Overview
    </h3>
    <!--end::Header-->

    <!--begin::Body-->
    <div class="mb-12">
        <?php $__currentLoopData = $listRows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <!--begin::Item-->
            <div class="d-flex align-items-center <?php echo e(util()->putIf(next($listRows), 'mb-7')); ?>">
                <!--begin::Symbol-->
                <div class="symbol symbol-50px me-5">
                    <span class="symbol-label bg-light-<?php echo e($row['color']); ?>">
                        <?php echo theme()->getSvgIcon($row['icon'], "svg-icon-2x svg-icon-" . $row['color']); ?>

                    </span>
                </div>
                <!--end::Symbol-->

                <!--begin::Text-->
                <div class="d-flex flex-column">
                    <a href=" <?php echo e(theme()->getPageUrl('pages/profile/overview')); ?>" class="text-gray-800 text-hover-primary fs-6 fw-bold"><?php echo e($row['title']); ?></a>

                    <span class="text-muted fw-bold"><?php echo e($row['description']); ?></span>
                </div>
                <!--end::Text-->
            </div>
            <!--end::Item-->
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <!--end::Body-->
</div>
<!--end::Tasks-->
<?php /**PATH C:\wamp64\www\keenthemes\themes\metronic\laravel\resources\views/layout/demo7/aside/__tab-contents/__tasks.blade.php ENDPATH**/ ?>