<?php
    $breadcrumb = bootstrap()->getBreadcrumb();
?>

<!--begin::Page title-->
<div <?php echo e(theme()->printHtmlAttributes("page-title")); ?> class="page-title d-flex align-items-center flex-wrap me-3 <?php echo e(theme()->printHtmlClasses('page-title', false)); ?>">
    <!--begin::Title-->
    <h1 class="d-flex align-items-center text-dark fw-bolder my-1 fs-3">
        <?php echo e(theme()->getOption('page', 'title')); ?>


        <?php if(!empty(theme()->hasOption('page', 'description')) && theme()->getOption('layout', 'page-title/description') !== false): ?>
            <!--begin::Separator-->
            <span class="h-20px border-gray-200 border-start ms-3 mx-2"></span>
            <!--end::Separator-->

            <!--begin::Description-->
            <small class="text-muted fs-7 fw-bold my-1 ms-1">
                <?php echo e(theme()->getOption('page', 'description')); ?>

            </small>
            <!--end::Description-->
        <?php endif; ?>
    </h1>
    <!--end::Title-->

    <?php if( theme()->getOption('layout', 'page-title/breadcrumb') === true && !empty($breadcrumb)): ?>
        <!--begin::Separator-->
        <span class="h-20px border-gray-200 border-start mx-3"></span>
        <!--end::Separator-->

        <!--begin::Breadcrumb-->
        <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
            <?php $__currentLoopData = $breadcrumb; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <!--begin::Item-->
                <?php if( $item['active'] === true ): ?>
                    <li class="breadcrumb-item text-dark">
                        <?php echo e($item['title']); ?>

                    </li>
                <?php else: ?>
                    <li class="breadcrumb-item text-muted">
                        <?php if( ! empty($item['path']) ): ?>
                            <a href="<?php echo e(theme()->getPageUrl($item['path'])); ?>" class="text-muted text-hover-primary">
                                <?php echo e($item['title']); ?>

                            </a>
                        <?php else: ?>
                            <?php echo e($item['title']); ?>

                        <?php endif; ?>
                    </li>
                <?php endif; ?>
                <!--end::Item-->

                <?php if(next($breadcrumb)): ?>
                    <!--begin::Item-->
                    <li class="breadcrumb-item">
                        <span class="bullet bg-gray-200 w-5px h-2px"></span>
                    </li>
                    <!--end::Item-->
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        <!--end::Breadcrumb-->
    <?php endif; ?>
</div>
<!--end::Page title-->
<?php /**PATH C:\wamp64\www\keenthemes\themes\metronic\laravel\resources\views/layout/demo6/_page-title.blade.php ENDPATH**/ ?>