<?php
    // Authors items
    $listRows = array(
        array(
            'avatar' => 'avatars/300-6.jpg',
            'name' => 'Emma Smith',
            'description' => 'Project Manager',
        ),

        array(
            'avatar' => 'avatars/300-5.jpg',
            'name' => 'Sean Bean',
            'description' => 'PHP, SQLite, Artisan CLI',
        ),

        array(
            'avatar' => 'avatars/300-11.jpg',
            'name' => 'Brian Cox',
            'description' => 'HTML5, jQuery, CSS3',
        ),

        array(
            'avatar' => 'avatars/300-23.jpg',
            'name' => 'Dan Wilson',
            'description' => 'MangoDB, Java',
        ),

        array(
            'avatar' => 'avatars/300-10.jpg',
            'name' => 'Natali Trump',
            'description' => 'NET, Oracle, MySQL',
        ),

        array(
            'avatar' => 'avatars/300-9.jpg',
            'name' => 'Francis Mitcham',
            'description' => 'React, Vue',
        ),

        array(
            'avatar' => 'avatars/300-12.jpg',
            'name' => 'Jessie Clarcson',
            'description' => 'Angular, React',
        )
    );
?>

<!--begin::Authors-->
<div class="mx-5">
    <!--begin::Header-->
    <h3 class="fw-bolder text-dark mx-0 mb-10">Authors</h3>
    <!--end::Header-->

    <!--begin::Body-->
    <div class="mb-12">
        <?php $__currentLoopData = $listRows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <!--begin::Item-->
            <div class="d-flex align-items-center <?php echo e(util()->putIf(next($listRows), 'mb-7')); ?>">
                <!--begin::Avatar-->
                <div class="symbol symbol-50px me-5">
                    <img src="<?php echo e(asset(theme()->getMediaUrlPath() . $row['avatar'])); ?>" class="" alt=""/>
                </div>
                <!--end::Avatar-->

                <!--begin::Text-->
                <div class="flex-grow-1">
                    <a href=" <?php echo e(theme()->getPageUrl('pages/projects/users')); ?>" class="text-dark fw-bolder text-hover-primary fs-6"><?php echo e($row['name']); ?></a>

                    <span class="text-muted d-block fw-bold"><?php echo e($row['description']); ?></span>
                </div>
                <!--end::Text-->
            </div>
            <!--end::Item-->
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <!--end::Body-->
</div>
<!--end::Authors-->
<?php /**PATH C:\wamp64\www\keenthemes\themes\metronic\laravel\resources\views/layout/demo7/aside/__tab-contents/__authors.blade.php ENDPATH**/ ?>