<!--begin::Basic info-->
<div class="card <?php echo e($class); ?>">
    <!--begin::Card header-->
    <div class="card-header border-0 cursor-pointer" role="button" data-bs-toggle="collapse" data-bs-target="#kt_account_profile_details" aria-expanded="true" aria-controls="kt_account_profile_details">
        <!--begin::Card title-->
        <div class="card-title m-0">
            <h3 class="fw-bolder m-0"><?php echo e(__('Profile Details')); ?></h3>
        </div>
        <!--end::Card title-->
    </div>
    <!--begin::Card header-->

    <!--begin::Content-->
    <div id="kt_account_profile_details" class="collapse show">
        <!--begin::Form-->
        <form id="kt_account_profile_details_form" class="form" method="POST" action="<?php echo e(route('settings.update')); ?>" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <!--begin::Card body-->
            <div class="card-body border-top p-9">
                <!--begin::Input group-->
                <div class="row mb-6">
                    <!--begin::Label-->
                    <label class="col-lg-4 col-form-label fw-bold fs-6"><?php echo e(__('Avatar')); ?></label>
                    <!--end::Label-->

                    <!--begin::Col-->
                    <div class="col-lg-8">
                        <!--begin::Image input-->
                        <div class="image-input image-input-outline <?php echo e(isset($info) && $info->avatar ? '' : 'image-input-empty'); ?>" data-kt-image-input="true" style="background-image: url(<?php echo e(asset(theme()->getMediaUrlPath() . 'avatars/blank.png')); ?>)">
                            <!--begin::Preview existing avatar-->
                            <div class="image-input-wrapper w-125px h-125px" style="background-image: <?php echo e(isset($info) && $info->avatar_url ? 'url('.asset($info->avatar_url).')' : 'none'); ?>;"></div>
                            <!--end::Preview existing avatar-->

                            <!--begin::Label-->
                            <label class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="change" data-bs-toggle="tooltip" title="Change avatar">
                                <i class="bi bi-pencil-fill fs-7"></i>

                                <!--begin::Inputs-->
                                <input type="file" name="avatar" accept=".png, .jpg, .jpeg"/>
                                <input type="hidden" name="avatar_remove"/>
                                <!--end::Inputs-->
                            </label>
                            <!--end::Label-->

                            <!--begin::Cancel-->
                            <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="cancel" data-bs-toggle="tooltip" title="Cancel avatar">
                                <i class="bi bi-x fs-2"></i>
                            </span>
                            <!--end::Cancel-->

                            <!--begin::Remove-->
                            <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="remove" data-bs-toggle="tooltip" title="Remove avatar">
                                <i class="bi bi-x fs-2"></i>
                            </span>
                            <!--end::Remove-->
                        </div>
                        <!--end::Image input-->

                        <!--begin::Hint-->
                        <div class="form-text">Allowed file types: png, jpg, jpeg.</div>
                        <!--end::Hint-->
                    </div>
                    <!--end::Col-->
                </div>
                <!--end::Input group-->

                <!--begin::Input group-->
                <div class="row mb-6">
                    <!--begin::Label-->
                    <label class="col-lg-4 col-form-label required fw-bold fs-6"><?php echo e(__('Full Name')); ?></label>
                    <!--end::Label-->

                    <!--begin::Col-->
                    <div class="col-lg-8">
                        <!--begin::Row-->
                        <div class="row">
                            <!--begin::Col-->
                            <div class="col-lg-6 fv-row">
                                <input type="text" name="first_name" class="form-control form-control-lg form-control-solid mb-3 mb-lg-0" placeholder="First name" value="<?php echo e(old('first_name', auth()->user()->first_name ?? '')); ?>"/>
                            </div>
                            <!--end::Col-->

                            <!--begin::Col-->
                            <div class="col-lg-6 fv-row">
                                <input type="text" name="last_name" class="form-control form-control-lg form-control-solid" placeholder="Last name" value="<?php echo e(old('last_name', auth()->user()->last_name ?? '')); ?>"/>
                            </div>
                            <!--end::Col-->
                        </div>
                        <!--end::Row-->
                    </div>
                    <!--end::Col-->
                </div>
                <!--end::Input group-->

                <!--begin::Input group-->
                <div class="row mb-6">
                    <!--begin::Label-->
                    <label class="col-lg-4 col-form-label fw-bold fs-6"><?php echo e(__('Company')); ?></label>
                    <!--end::Label-->

                    <!--begin::Col-->
                    <div class="col-lg-8 fv-row">
                        <input type="text" name="company" class="form-control form-control-lg form-control-solid" placeholder="Company name" value="<?php echo e(old('company', $info->company ?? '')); ?>"/>
                    </div>
                    <!--end::Col-->
                </div>
                <!--end::Input group-->

                <!--begin::Input group-->
                <div class="row mb-6">
                    <!--begin::Label-->
                    <label class="col-lg-4 col-form-label fw-bold fs-6">
                        <span class="required"><?php echo e(__('Contact Phone')); ?></span>

                        <i class="fas fa-exclamation-circle ms-1 fs-7" data-bs-toggle="tooltip" title="<?php echo e(__('Phone number must be active')); ?>"></i>
                    </label>
                    <!--end::Label-->

                    <!--begin::Col-->
                    <div class="col-lg-8 fv-row">
                        <input type="tel" name="phone" class="form-control form-control-lg form-control-solid" placeholder="Phone number" value="<?php echo e(old('phone', $info->phone ?? '')); ?>"/>
                    </div>
                    <!--end::Col-->
                </div>
                <!--end::Input group-->

                <!--begin::Input group-->
                <div class="row mb-6">
                    <!--begin::Label-->
                    <label class="col-lg-4 col-form-label fw-bold fs-6"><?php echo e(__('Company Site')); ?></label>
                    <!--end::Label-->

                    <!--begin::Col-->
                    <div class="col-lg-8 fv-row">
                        <input type="text" name="website" class="form-control form-control-lg form-control-solid" placeholder="Company website" value="<?php echo e(old('website', $info->website ?? '')); ?>"/>
                    </div>
                    <!--end::Col-->
                </div>
                <!--end::Input group-->

                <!--begin::Input group-->
                <div class="row mb-6">
                    <!--begin::Label-->
                    <label class="col-lg-4 col-form-label fw-bold fs-6">
                        <span class="required"><?php echo e(__('Country')); ?></span>

                        <i class="fas fa-exclamation-circle ms-1 fs-7" data-bs-toggle="tooltip" title="<?php echo e(__('Country of origination')); ?>"></i>
                    </label>
                    <!--end::Label-->

                    <!--begin::Col-->
                    <div class="col-lg-8 fv-row">
                        <select name="country" aria-label="<?php echo e(__('Select a Country')); ?>" data-control="select2" data-placeholder="<?php echo e(__('Select a country...')); ?>" class="form-select form-select-solid form-select-lg fw-bold">
                            <option value=""><?php echo e(__('Select a Country...')); ?></option>
                            <?php $__currentLoopData = \App\Core\Data::getCountriesList(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option data-kt-flag="<?php echo e($value['flag']); ?>" value="<?php echo e($key); ?>" <?php echo e($key === old('country', $info->country ?? '') ? 'selected' :''); ?>><?php echo e($value['name']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <!--end::Col-->
                </div>
                <!--end::Input group-->

                <!--begin::Input group-->
                <div class="row mb-6">
                    <!--begin::Label-->
                    <label class="col-lg-4 col-form-label required fw-bold fs-6"><?php echo e(__('Language')); ?></label>
                    <!--end::Label-->

                    <!--begin::Col-->
                    <div class="col-lg-8 fv-row">
                        <!--begin::Input-->
                        <select name="language" aria-label="<?php echo e(__('Select a Language')); ?>" data-control="select2" data-placeholder="<?php echo e(__('Select a language...')); ?>" class="form-select form-select-solid form-select-lg">
                            <option value=""><?php echo e(__('Select a Language...')); ?></option>
                            <?php $__currentLoopData = \App\Core\Data::getLanguagesList(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option data-kt-flag="<?php echo e($value['country']['flag']); ?>" value="<?php echo e($key); ?>" <?php echo e($key === old('language', $info->language ?? '') ? 'selected' :''); ?>><?php echo e($value['name']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <!--end::Input-->

                        <!--begin::Hint-->
                        <div class="form-text">
                            <?php echo e(__('Please select a preferred language, including date, time, and number formatting.')); ?>

                        </div>
                        <!--end::Hint-->
                    </div>
                    <!--end::Col-->
                </div>
                <!--end::Input group-->

                <!--begin::Input group-->
                <div class="row mb-6">
                    <!--begin::Label-->
                    <label class="col-lg-4 col-form-label required fw-bold fs-6"><?php echo e(__('Time Zone')); ?></label>
                    <!--end::Label-->

                    <!--begin::Col-->
                    <div class="col-lg-8 fv-row">
                        <select name="timezone" aria-label="<?php echo e(__('Select a Timezone')); ?>" data-control="select2" data-placeholder="<?php echo e(__('Select a timezone..')); ?>" class="form-select form-select-solid form-select-lg">
                            <option value=""><?php echo e(__('Select a Timezone..')); ?></option>
                            <?php $__currentLoopData = \App\Core\Data::getTimeZonesList(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option data-bs-offset="<?php echo e($value['offset']); ?>" value="<?php echo e($key); ?>" <?php echo e($key === old('timezone', $info->timezone ?? '') ? 'selected' :''); ?>><?php echo e($value['name']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <!--end::Col-->
                </div>
                <!--end::Input group-->

                <!--begin::Input group-->
                <div class="row mb-6">
                    <!--begin::Label-->
                    <label class="col-lg-4 col-form-label  fw-bold fs-6"><?php echo e(__('Currency')); ?></label>
                    <!--end::Label-->

                    <!--begin::Col-->
                    <div class="col-lg-8 fv-row">
                        <select name="currency" aria-label="<?php echo e(__('Select a Currency')); ?>" data-control="select2" data-placeholder="<?php echo e(__('Select a currency..')); ?>" class="form-select form-select-solid form-select-lg">
                            <option value=""><?php echo e(__('Select a currency..')); ?></option>
                            <?php $__currentLoopData = \App\Core\Data::getCurrencyList(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option data-kt-flag="<?php echo e($value['country']['flag']); ?>" value="<?php echo e($key); ?>" <?php echo e($key === old('currency', $info->currency ?? '') ? 'selected' :''); ?>><b><?php echo e($key); ?></b>&nbsp;-&nbsp;<?php echo e($value['name']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <!--end::Col-->
                </div>
                <!--end::Input group-->

                <!--begin::Input group-->
                <div class="row mb-6">
                    <!--begin::Label-->
                    <label class="col-lg-4 col-form-label fw-bold fs-6"><?php echo e(__('Communication')); ?></label>
                    <!--end::Label-->

                    <!--begin::Col-->
                    <div class="col-lg-8 fv-row">
                        <!--begin::Options-->
                        <div class="d-flex align-items-center mt-3">
                            <!--begin::Option-->
                            <label class="form-check form-check-inline form-check-solid me-5">
                                <input type="hidden" name="communication[email]" value="0">
                                <input class="form-check-input" name="communication[email]" type="checkbox" value="1" <?php echo e(old('marketing', $info->communication['email'] ?? '') ? 'checked' : ''); ?>/>
                                <span class="fw-bold ps-2 fs-6">
                                    <?php echo e(__('Email')); ?>

                                </span>
                            </label>
                            <!--end::Option-->

                            <!--begin::Option-->
                            <label class="form-check form-check-inline form-check-solid">
                                <input type="hidden" name="communication[phone]" value="0">
                                <input class="form-check-input" name="communication[phone]" type="checkbox" value="1" <?php echo e(old('email', $info->communication['phone'] ?? '') ? 'checked' : ''); ?>/>
                                <span class="fw-bold ps-2 fs-6">
                                    <?php echo e(__('Phone')); ?>

                                </span>
                            </label>
                            <!--end::Option-->
                        </div>
                        <!--end::Options-->
                    </div>
                    <!--end::Col-->
                </div>
                <!--end::Input group-->

                <!--begin::Input group-->
                <div class="row mb-0">
                    <!--begin::Label-->
                    <label class="col-lg-4 col-form-label fw-bold fs-6"><?php echo e(__('Allow Marketing')); ?></label>
                    <!--begin::Label-->

                    <!--begin::Label-->
                    <div class="col-lg-8 d-flex align-items-center">
                        <div class="form-check form-check-solid form-check-custom form-switch fv-row">
                            <input type="hidden" name="marketing" value="0">
                            <input class="form-check-input w-45px h-30px" type="checkbox" id="allowmarketing" name="marketing" value="1" <?php echo e(old('marketing', $info->marketing ?? '') ? 'checked' : ''); ?>/>
                            <label class="form-check-label" for="allowmarketing"></label>
                        </div>
                    </div>
                    <!--begin::Label-->
                </div>
                <!--end::Input group-->
            </div>
            <!--end::Card body-->

            <!--begin::Actions-->
            <div class="card-footer d-flex justify-content-end py-6 px-9">
                <button type="reset" class="btn btn-white btn-active-light-primary me-2"><?php echo e(__('Discard')); ?></button>

                <button type="submit" class="btn btn-primary" id="kt_account_profile_details_submit">
                    <?php echo $__env->make('partials.general._button-indicator', ['label' => __('Save Changes')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </button>
            </div>
            <!--end::Actions-->
        </form>
        <!--end::Form-->
    </div>
    <!--end::Content-->
</div>
<!--end::Basic info-->
<?php /**PATH C:\wamp64\www\keenthemes\themes\metronic\laravel\resources\views/pages/account/settings/_profile-details.blade.php ENDPATH**/ ?>